/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/**************************************************************/
/* File seq_bool.h                                            */
/* defines the structure of a boolean function map            */
/* 1997 Robert Siegmund                                       */
/**************************************************************/
#ifndef _SEQ_BOOL_H_
#define _SEQ_BOOL_H_

/* A boolean function map consists of a dynamically allocated */
/* array of characters (8 bit chunks)                         */
/* mapsize is the size of the boolean map in bits and is      */
/* always a power of 2                                        */

typedef struct { char * map_ptr;
                 int fcn_vars;  
                 int map_size;
               } boolmap;

/* function prototypes */

   
boolmap * alloc_boolmap(int, int);
void  dealloc_boolmap(boolmap *);
boolmap * not_boolmap(boolmap *);
boolmap * and_boolmap(boolmap *, boolmap *);
boolmap *  or_boolmap(boolmap *, boolmap *);
boolmap * xor_boolmap(boolmap *, boolmap *);
int       cmp_boolmap(boolmap *, boolmap *);
boolmap * add_boolmap(boolmap *, boolmap *);
int  get_boolmap_bit(boolmap *, int);
void display_boolmap(boolmap *, char );

#endif

